---
title: Under a DDoS attack? · Cloudflare Fundamentals docs
description: Learn a few ways to tell if your application is under a DDoS attack.
lastUpdated: 2025-05-07T13:46:29.000Z
chatbotDeprioritize: false
source_url:
  html: https://developers.cloudflare.com/fundamentals/security/under-ddos-attack/
  md: https://developers.cloudflare.com/fundamentals/security/under-ddos-attack/index.md
---

A distributed denial-of-service (DDoS) attack is where a large number of computers or devices, usually controlled by a single attacker, attempt to access a website or online service all at once. This flood of traffic can overwhelm the website's origin servers, causing the site to slow down or even crash.

```mermaid
sequenceDiagram;
    participant User;
    participant Website;
    participant Server;
    participant Botnet;
    User->>Website: Requests to access site
    Website->>Origin Server: Processes user requests
    Botnet->>Origin Server: Sends a flood of traffic
    Origin Server-->>Website: Slows down due to traffic overload
    Origin Server-->>User: Unable to respond to user requests
```



## Common signs of an attack

Common signs that you are under DDoS attack include:

* Your site is offline or slow to respond to requests.
* Unexpected spikes appear in the graph of **Requests Through Cloudflare** or **Bandwidth** in your Cloudflare **Analytics** app.
* Strange requests appear in your origin web server logs that do not match normal visitor behavior.

Note

If you are currently under DDoS attack, refer to our guide on [responding to a DDoS attack](https://developers.cloudflare.com/ddos-protection/best-practices/respond-to-ddos-attacks/).
